/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.Platform;
import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.provider.StringIO;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class AbstractArrayMemoryIO
extends AbstractMemoryIO {
    protected static final ArrayIO IO = AbstractArrayMemoryIO.getArrayIO();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected final byte[] buffer;
    protected final int offset;
    protected final int length;

    public AbstractArrayMemoryIO(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.offset = n;
        this.length = n2;
    }

    public AbstractArrayMemoryIO(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public AbstractArrayMemoryIO(int n) {
        this(new byte[n], 0, n);
    }

    public final byte[] array() {
        return this.buffer;
    }

    public final int offset() {
        return this.offset;
    }

    public final int length() {
        return this.length;
    }

    public final boolean isDirect() {
        return false;
    }

    public long address() {
        throw new UnsupportedOperationException("Not a direct memory object");
    }

    private static final ArrayIO getArrayIO() {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return Platform.getPlatform().addressSize() == 64 ? AbstractArrayMemoryIO.newBE64ArrayIO() : AbstractArrayMemoryIO.newBE32ArrayIO();
        }
        return Platform.getPlatform().addressSize() == 64 ? AbstractArrayMemoryIO.newLE64ArrayIO() : AbstractArrayMemoryIO.newLE32ArrayIO();
    }

    private static final ArrayIO newBE64ArrayIO() {
        return new BE64ArrayIO();
    }

    private static final ArrayIO newBE32ArrayIO() {
        return new BE32ArrayIO();
    }

    private static final ArrayIO newLE64ArrayIO() {
        return new LE64ArrayIO();
    }

    private static final ArrayIO newLE32ArrayIO() {
        return new LE32ArrayIO();
    }

    protected final int index(long l) {
        return this.offset + (int)l;
    }

    public final boolean isNull() {
        return false;
    }

    public String getString(long l) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer, this.index(l), this.length - (int)l);
        return ((Object)StringIO.getStringIO().fromNative(byteBuffer, this.length - (int)l)).toString();
    }

    public String getString(long l, int n, Charset charset) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer, this.index(l), this.length - (int)l);
        return ((Object)StringIO.getStringIO().fromNative(byteBuffer, Math.min(n, this.length - (int)l))).toString();
    }

    public void putString(long l, String string, int n, Charset charset) {
        StringIO.getStringIO().toNative(string, ByteBuffer.wrap(this.buffer, this.index(l), Math.min(n, this.length - (int)l)));
    }

    public final byte getByte(long l) {
        return (byte)(this.buffer[this.index(l)] & 0xFF);
    }

    public final short getShort(long l) {
        return IO.getInt16(this.buffer, this.index(l));
    }

    public final int getInt(long l) {
        return IO.getInt32(this.buffer, this.index(l));
    }

    public final long getLong(long l) {
        return IO.getInt64(this.buffer, this.index(l));
    }

    public final long getAddress(long l) {
        return IO.getAddress(this.buffer, this.index(l));
    }

    public final float getFloat(long l) {
        return IO.getFloat32(this.buffer, this.index(l));
    }

    public final double getDouble(long l) {
        return IO.getFloat64(this.buffer, this.index(l));
    }

    public final void putByte(long l, byte by) {
        this.buffer[this.index((long)l)] = by;
    }

    public final void putShort(long l, short s) {
        IO.putInt16(this.buffer, this.index(l), s);
    }

    public final void putInt(long l, int n) {
        IO.putInt32(this.buffer, this.index(l), n);
    }

    public final void putLong(long l, long l2) {
        IO.putInt64(this.buffer, this.index(l), l2);
    }

    public final void putAddress(long l, long l2) {
        IO.putAddress(this.buffer, this.index(l), l2);
    }

    public final void putFloat(long l, float f) {
        IO.putFloat32(this.buffer, this.index(l), f);
    }

    public final void putDouble(long l, double d) {
        IO.putFloat64(this.buffer, this.index(l), d);
    }

    public final void get(long l, byte[] byArray, int n, int n2) {
        System.arraycopy(this.buffer, this.index(l), byArray, n, n2);
    }

    public final void put(long l, byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.buffer, this.index(l), n2);
    }

    public final void get(long l, short[] sArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = IO.getInt16(this.buffer, n3 + (i << 1));
        }
    }

    public final void put(long l, short[] sArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putInt16(this.buffer, n3 + (i << 1), sArray[n + i]);
        }
    }

    public final void get(long l, int[] nArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = IO.getInt32(this.buffer, n3 + (i << 2));
        }
    }

    public final void put(long l, int[] nArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putInt32(this.buffer, n3 + (i << 2), nArray[n + i]);
        }
    }

    public final void get(long l, long[] lArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = IO.getInt64(this.buffer, n3 + (i << 3));
        }
    }

    public final void put(long l, long[] lArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putInt64(this.buffer, n3 + (i << 3), lArray[n + i]);
        }
    }

    public final void get(long l, float[] fArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = IO.getFloat32(this.buffer, n3 + (i << 2));
        }
    }

    public final void put(long l, float[] fArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putFloat32(this.buffer, n3 + (i << 2), fArray[n + i]);
        }
    }

    public final void get(long l, double[] dArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = IO.getFloat64(this.buffer, n3 + (i << 3));
        }
    }

    public final void put(long l, double[] dArray, int n, int n2) {
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putFloat64(this.buffer, n3 + (i << 3), dArray[n + i]);
        }
    }

    public final int indexOf(long l, byte by) {
        int n = this.index(l);
        for (int i = 0; i < this.length; ++i) {
            if (this.buffer[n + i] != by) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(long l, byte by, int n) {
        int n2 = this.index(l);
        for (int i = 0; i < Math.min(this.length, n); ++i) {
            if (this.buffer[n2 + i] != by) continue;
            return i;
        }
        return -1;
    }

    public final void setMemory(long l, long l2, byte by) {
        Arrays.fill(this.buffer, this.index(l), (int)l2, by);
    }

    public final void clear() {
        Arrays.fill(this.buffer, this.offset, this.length, (byte)0);
    }

    protected static abstract class ArrayIO {
        protected ArrayIO() {
        }

        public abstract short getInt16(byte[] var1, int var2);

        public abstract int getInt32(byte[] var1, int var2);

        public abstract long getInt64(byte[] var1, int var2);

        public abstract long getAddress(byte[] var1, int var2);

        public abstract void putInt16(byte[] var1, int var2, int var3);

        public abstract void putInt32(byte[] var1, int var2, int var3);

        public abstract void putInt64(byte[] var1, int var2, long var3);

        public abstract void putAddress(byte[] var1, int var2, long var3);

        public final float getFloat32(byte[] byArray, int n) {
            return Float.intBitsToFloat(this.getInt32(byArray, n));
        }

        public final void putFloat32(byte[] byArray, int n, float f) {
            this.putInt32(byArray, n, Float.floatToRawIntBits(f));
        }

        public final double getFloat64(byte[] byArray, int n) {
            return Double.longBitsToDouble(this.getInt64(byArray, n));
        }

        public final void putFloat64(byte[] byArray, int n, double d) {
            this.putInt64(byArray, n, Double.doubleToRawLongBits(d));
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        private BE32ArrayIO() {
        }

        public final long getAddress(byte[] byArray, int n) {
            return (long)this.getInt32(byArray, n) & 0xFFFFFFFFL;
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putInt32(byArray, n, (int)l);
        }
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        private BE64ArrayIO() {
        }

        public final long getAddress(byte[] byArray, int n) {
            return this.getInt64(byArray, n);
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putInt64(byArray, n, l);
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public short getInt16(byte[] byArray, int n) {
            return (short)((byArray[n + 0] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
        }

        public int getInt32(byte[] byArray, int n) {
            return (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 3] & 0xFF) << 0;
        }

        public long getInt64(byte[] byArray, int n) {
            return ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | ((long)byArray[n + 7] & 0xFFL) << 0;
        }

        public final void putInt16(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 8);
            byArray[n + 1] = (byte)(n2 >> 0);
        }

        public final void putInt32(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 24);
            byArray[n + 1] = (byte)(n2 >> 16);
            byArray[n + 2] = (byte)(n2 >> 8);
            byArray[n + 3] = (byte)(n2 >> 0);
        }

        public final void putInt64(byte[] byArray, int n, long l) {
            byArray[n + 0] = (byte)(l >> 56);
            byArray[n + 1] = (byte)(l >> 48);
            byArray[n + 2] = (byte)(l >> 40);
            byArray[n + 3] = (byte)(l >> 32);
            byArray[n + 4] = (byte)(l >> 24);
            byArray[n + 5] = (byte)(l >> 16);
            byArray[n + 6] = (byte)(l >> 8);
            byArray[n + 7] = (byte)(l >> 0);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        private LE32ArrayIO() {
        }

        public final long getAddress(byte[] byArray, int n) {
            return (long)this.getInt32(byArray, n) & 0xFFFFFFFFL;
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putInt32(byArray, n, (int)l);
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        private LE64ArrayIO() {
        }

        public final long getAddress(byte[] byArray, int n) {
            return this.getInt64(byArray, n);
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putInt64(byArray, n, l);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final short getInt16(byte[] byArray, int n) {
            return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
        }

        public final int getInt32(byte[] byArray, int n) {
            return (byArray[n + 0] & 0xFF) << 0 | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        public final long getInt64(byte[] byArray, int n) {
            return ((long)byArray[n + 0] & 0xFFL) << 0 | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
        }

        public final void putInt16(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 0);
            byArray[n + 1] = (byte)(n2 >> 8);
        }

        public final void putInt32(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 0);
            byArray[n + 1] = (byte)(n2 >> 8);
            byArray[n + 2] = (byte)(n2 >> 16);
            byArray[n + 3] = (byte)(n2 >> 24);
        }

        public final void putInt64(byte[] byArray, int n, long l) {
            byArray[n + 0] = (byte)(l >> 0);
            byArray[n + 1] = (byte)(l >> 8);
            byArray[n + 2] = (byte)(l >> 16);
            byArray[n + 3] = (byte)(l >> 24);
            byArray[n + 4] = (byte)(l >> 32);
            byArray[n + 5] = (byte)(l >> 40);
            byArray[n + 6] = (byte)(l >> 48);
            byArray[n + 7] = (byte)(l >> 56);
        }
    }
}

